﻿using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using System.Web.OData;
using System.Web.OData.Routing;
using Microsoft.Xrm.Sdk;
using PpmsDataService.V1.Mappers;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;
using System.Net;
using System.Net.Http;
using Microsoft.Web.Http;

namespace PpmsDataService.V1.Controllers
{
    [EnableQuery]
    //[Authorize]
    [ApiVersion("1.0")]
    public class ProviderLicensesController : ODataController
    {
        [ODataRoute("ProviderLicenses('{key}')")]
        public async Task<HttpResponseMessage> Get([FromODataUri] string key)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderLicense =
                    context.ppms_providerlicensureSet.FirstOrDefault(x => x.ppms_name.Equals(key));
                if (ppmsProviderLicense != null)
                {
                    var ppmsProviderLicensesList = new List<ppms_providerlicensure> {ppmsProviderLicense};
                    var providerLicenses = await ProviderLicensesMap.MapProviderLicenses(ppmsProviderLicensesList, queryType, context);
                    return Request.CreateResponse(providerLicenses);            
                }
                var message = string.Format("Provider License with Number: {0} not found", key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        //Returns only the related Provider Licenses       
        [ODataRoute("ProviderLicenses('{key}')/Provider")]
        public async Task<HttpResponseMessage> GetProvider([FromODataUri] string key)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderLicense =
                    context.ppms_providerlicensureSet.FirstOrDefault(x => x.ppms_name.Equals(key));
                if (ppmsProviderLicense != null)
                {
                    //Retrieve and Return the related Provider
                    var ppmsProvider =
                        context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderLicense.ppms_ProviderIdId.Id);
                    var ppmsProvidersList = new List<Account> { ppmsProvider };
                    var provider =
                        await ProviderMap.MapProviders(ppmsProvidersList, "None", context);
                    return Request.CreateResponse(provider);
                }
                var message = string.Format("Provider with Provider License Number: {0} not found", key);
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        [ODataRoute("ProviderLicenses")]
        public async Task<HttpResponseMessage> Get()
        {
            //This Scenario returns the first 50 Providers in the system. . 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderLicenses = context.ppms_providerlicensureSet.Where(i => i.ppms_name != null && i.ppms_ProviderIdId !=null).Take(50);
                var ppmsProviderLicensesList = ppmsProviderLicenses.ToList();
                if (ppmsProviderLicensesList.Any())
                {
                    //Map Providers
                    var providerLicenses = await ProviderLicensesMap.MapProviderLicenses(ppmsProviderLicensesList, "None", context);
                    return Request.CreateResponse(providerLicenses);
                }
                var message = "Provider Licenses Not Found";
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }
    }
}